/*
 * Dither matrix data
 *
 * This file is placed in the public domain.
 */

#ifndef AVFILTER_DITHER_MATRIX_H
#define AVFILTER_DITHER_MATRIX_H

#include <stdint.h>
static const int ff_fruit_dither_size = 64;
static const uint16_t ff_fruit_dither_matrix[] = {
	 332, 2776, 1933,   42, 2598, 1796, 1000, 2978, 1677, 3452, 2164, 1564, 2644,  358, 2012, 3471, 1147, 3071,  596, 1943, 3146, 1191, 2469,  919, 3664, 2359,  441, 2691, 1179, 3027, 1408,  298, 3892, 1825,  182, 2178, 3028,  317, 2412,  858, 3097, 2205, 1145, 2880,  990, 2697,  728, 1969, 2312, 1393, 3232, 1204, 3752, 1529,  448, 3955, 2076,  833, 3856,    1, 3445, 2105,  955, 1761,
	4060, 1053, 3038, 1445, 3302,  430, 3702, 2119,  625, 2523,   12, 3003,  959, 3814, 2388,  829, 4059, 2236, 1417, 3447,  198, 4020, 1891, 3368,   76, 1460, 2963, 1680, 3721,  535, 2275, 2916, 1226, 2348, 3580,  823, 1897, 4032, 1245, 2728,  194, 3285, 1941,  399, 3639, 1593, 3775, 1038, 3012,  162, 2687, 2029,  559, 2983, 1809, 2378,  325, 2861, 1331, 2533, 1171, 2701, 3328,  153,
	2214, 3412,  501, 3934,  892, 1918, 2686, 1199, 3090, 1351, 3779, 1776, 3371, 1457,  217, 2844, 1726,  311, 2896, 1021, 2604, 1546,  569, 2758, 1818, 3967,  727, 3305,  963, 1866, 3591,  853, 3215,  496, 2651, 1453, 2808,  704, 2247, 3395, 1779,  937, 4014, 2288, 1286, 3110,  331, 3309, 1839, 3866,  932, 3566, 2499, 1005, 3346, 1192, 3712, 1743, 3399,  757, 3765,  391, 1871, 2928,
	1411,  820, 2531, 1622, 2192, 3478,  215, 4079,  384, 3298,  742, 2332,  436, 2685, 1963, 3273,  680, 3571, 2033, 3795,  806, 3550, 2319, 1225, 3191, 1027, 2506,  237, 2196, 3126,   28, 2148, 1772, 3959, 1009, 3507,   85, 3742, 1539,  453, 3647, 2154,  573, 2786,  156, 2020, 2569, 1425,  538, 2375, 1723,  300, 1854, 4065,  110, 2741,  678, 3138,  213, 1979, 2330, 1530, 3542,  720,
	3811, 1955, 3240,  126, 2909,  760, 2482, 1493, 2301, 1719, 2788, 1180, 3998,  923, 3649, 1094, 1862, 2579, 1272,   30, 3109, 1987,  255, 3816,  471, 1977, 3519, 1557, 3882, 1086, 2754, 3776, 1304,  241, 2262, 1863, 3163, 1111, 2982, 2026, 1056, 2948, 1439, 3323, 1737, 3595,  860, 3980, 2895, 1193, 3365, 2779,  852, 2175, 3069, 1641, 2309, 1237, 2630, 4036,  965, 3052, 1096, 2487,
	 289, 2863, 1190, 3633, 1330, 3834, 1075, 3429,  602, 3850,  174, 3242, 1657, 3080,   98, 2357, 3899,  374, 3224, 1619, 2431, 1125, 3019, 1367, 2395, 3102,  794, 2850,  426, 2451, 1687,  548, 3070, 2596, 3335,  565, 1630, 2459,  288, 3937, 2504,   51, 3740,  725, 2475,  433, 2706, 2075,   19, 3694,  633, 1982, 3149, 1345,  729, 3843,  411, 3654, 1681,  564, 2721,  104, 3875, 2110,
	3504, 1730,  537, 2398, 2058,  443, 2636, 1802, 2925,  953, 2568, 2005,  583, 2108, 2802, 1441,  889, 2726, 1949, 3984,  486, 3407,  624, 2698, 1648,   97, 4055, 1340, 1994, 3667,  913, 3453, 1964,  815, 1400, 4072, 2767,  873, 3457,  684, 1576, 3119, 1884, 1222, 3898, 1535, 3482,  982, 1817, 2520, 1487, 3927,  181, 3493, 2396, 1438, 2871,  985, 2070, 3498, 1370, 3279, 1655,  586,
	1280, 2625, 3912,  939, 2999, 1649, 3162,   64, 2130, 3606, 1428, 3469, 1256, 3824,  409, 3562, 1780, 3433,  768, 1206, 2843, 2086, 3869,  926, 3663, 2099, 1047, 2623, 3217,  148, 1810, 2498,  314, 3790, 2126,  129, 2037, 3088, 1356, 2314, 3301,  946, 2716, 2163,  250, 3091,  575, 2227, 3204,  359, 2970, 1110, 2594, 1867,  532, 3338,   43, 2492, 3172,  282, 2394,  842, 2852, 2019,
	3111,   31, 1813, 3256,  243, 3687,  851, 4002, 1301,  480, 3004,  264, 2493, 1586, 2947,  714, 2538,  165, 2193, 3597, 1514,  130, 1792, 3132,  348, 2875, 3434,  491, 1251, 2120, 3979, 1093, 2905,  979, 2561, 3625, 1230,  373, 3836, 1953,  197, 4028,  498, 3383, 1713, 2400, 1402, 4083, 1150, 3589, 2106,  592, 3650, 1252, 4012, 1975, 3047, 1574,  690, 3909, 1745, 3616,  349, 3976,
	 894, 3438, 2251, 1160, 2582, 1467, 2342, 1747, 2837, 2242, 1076, 3946,  866, 3385, 1108, 1985, 4076, 1303, 2915,  438, 2589, 3312, 1085, 2367, 1916, 1403,  759, 2340, 3582, 2835,  637, 3264, 1997, 3506,  515, 1544, 3258, 2612, 1017, 2903, 1322, 1791, 3014, 1154, 3826,  871, 2858,  192, 2739,  719, 1701, 3177, 2222,  345, 2737,  770, 1181, 3774, 2264, 1060, 2667, 1262, 2318, 1584,
	2654, 1420,  499, 4045,  688, 3379,  319, 3490,  735, 3699, 1642, 2050, 2683,   40, 2204, 3096,  343, 3261, 1672, 3747,  900, 1981, 4025,  644, 3505, 2575, 3903, 1724,  232, 1517, 2590, 1405,   58, 1663, 3051, 2381,  751, 1756, 3646,  647, 3464, 2363,  826, 2563,   92, 3137, 1928, 3524, 1590, 2159, 3851,   84, 1423, 3082, 1684, 2417, 3417,  369, 1808, 3022,  118, 3254,  661, 3555,
	 229, 3756, 2917, 1627, 2773, 1235, 2949, 1002, 2470,  140, 3274,  594, 3533, 1678, 3799,  933, 1812, 2457,  673, 2306, 1474, 3055,  292, 2820, 1293,    2, 1106, 3237, 2013, 3823,  439, 3611, 2093, 4015, 1264,  258, 3914, 2294,   16, 2692, 1983,  295, 3723, 1893, 3442, 1306,  619, 2371,  392, 2989, 1071, 2484, 3512,  666, 3796,  195, 1522, 2775, 3586,  875, 4086, 1921, 2883, 1163,
	2456, 1935, 1032, 2305,  111, 3845, 2036, 1555, 3964, 2115, 1289, 2911,  977, 2372,  465, 2616, 3618, 1211, 3933,   72, 3404,  772, 2424, 1662, 3755, 2252, 3025,  518, 2524,  855, 2953, 1102, 2811,  795, 2602, 3414, 2060,  891, 3357, 1132, 3965, 1495, 2806,  551, 1633, 2629, 3659, 1172, 3958, 1446, 3319,  798, 1787, 2768, 1271, 3184, 2210,  587, 1338, 2478, 1550,  483, 2198, 3388,
	 832, 3219,  386, 3674, 1733, 2479,  578, 3214,  416, 3044, 1861,  291, 4033, 1449, 3477, 1940,  205, 2976,  885, 2704, 1886, 3820, 1070, 3288,  700, 1369, 1855, 4087, 1194, 3463, 1764, 2329,  297, 3296, 1742,  539, 1398, 3107, 1696, 2387,  711, 3151, 1223, 2219, 4038,  328, 2095, 2919,  845, 2595,  263, 2235, 4043,  398, 2129,  903, 3924, 1885, 3317,  249, 2732, 3685, 1383,   55,
	3926, 1481, 2977, 1177, 3292,  893, 3600, 1418, 2670,  927, 3637, 2477, 1127, 2665,  765, 2879, 1283, 2162, 3333, 1359,  482, 2180, 2942,  219, 2548, 3594,  308, 2759, 2185,  106, 3174,  699, 3738, 1139, 2277, 3833, 2804,  223, 3707,  415, 3518, 1913,  150, 2995,  864, 3222, 1575,   35, 3428, 1694, 3581,  992, 2907, 1494, 3676, 2702,   11, 3103,  849, 3825, 1848,  947, 3125, 1901,
	2494,  600, 2017, 2658,  293, 2207, 2851,    9, 1799, 3186,  510, 2077, 3318,  102, 3196, 1571, 3982,  357, 1781, 3717, 2774, 1176, 1834, 4001,  908, 2044, 3195,  986, 1675, 3696, 1339, 2638, 1617, 3026,   96, 1984,  940, 2446, 1563, 2876,  930, 2532, 3426, 1516, 2407, 1134, 3801, 1931, 2307,  521, 2744, 1883,  138, 3356,  597, 1758, 2343, 1389, 2831, 2145,  693, 3485, 2286,  520,
	3031, 1601, 3710,  956, 4067, 1849, 1097, 3760, 2406, 1215, 3861, 1596,  846, 3804, 1890,  516, 2295, 3062,  747, 2337,  169, 3178,  603, 2269, 3104, 1537,  627, 3537, 2415,  786, 2988,  379, 4040,  839, 2554, 3561, 1363, 4005,  745, 2128, 3817, 1348,  617, 3910,  397, 3050,  598, 2787, 1037, 3932, 1277, 3741, 2091, 1073, 2503, 3530,  934, 4024,  352, 1610, 2969,  158, 1347, 3992,
	1155, 3348,  142, 2259, 3087,  500, 3380, 2096,  730, 2795,  210, 3005, 2335, 1173, 2627, 3703, 1049, 2038, 3514,  983, 3868, 1653, 3552, 1249,   74, 3891, 2586, 1452,  238, 3936, 1738, 2168, 1209, 3384, 1847,  593, 3233,  355, 3036, 1753,   63, 3250, 2150, 1732, 2613, 1259, 3629, 1483, 3120,  280, 2382,  663, 2641, 3176, 1637,  265, 3013, 1239, 2420, 3416, 1088, 3769, 1938, 2555,
	 347, 2049, 2809, 1443,  761, 2628, 1693,  277, 3975, 1496, 3523, 1961,  547, 3106,  287, 1492, 3340,   24, 1547, 2887, 2147,  370, 2535, 1880, 2962, 2121,  479, 3077, 1922, 2618,  966, 3253, 2439,  327, 2847, 1515, 2226, 2713,  962, 3632, 2465, 1039, 2854,  245, 3179, 2080,  124, 2525,  792, 3486, 1744, 3289, 1404,  476, 3782, 2186,  715, 3579, 1971,  626, 2784, 2201,  741, 3248,
	1640, 3551, 1024, 3840, 1827, 3622, 1072, 3238, 2279,  835, 2562, 1295, 4085, 1816, 3535, 2495,  724, 2664, 4042,  570, 1281, 3422, 1013, 3787,  783, 1343, 3722, 1123, 3427,  599, 3634,   27, 1572, 3827, 1014, 3665,  139, 1868, 3197, 1390,  640, 4090, 1459, 3714,  902, 3421, 1676, 4004, 2246, 1128, 2720,   60, 4069, 2002, 1035, 2818, 1352, 2552,   88, 3847, 1801,  309, 3627, 1104,
	2894,  686, 2509,  403, 2926,   95, 1991, 2868,  469, 2052, 3370,   66, 2399,  679, 1248, 2081, 3181, 1100, 2224, 1870, 3001, 1506, 2760,  260, 3294, 2707, 2027,  146, 2355, 1323, 2783, 1956, 2946,  676, 2000, 3053, 1325, 3893,  424, 2084, 2998, 1797,  466, 2380, 1875,  507, 2939, 1054,  396, 3700, 1502, 3007,  904, 2418, 3443,  200, 3954, 1588, 3283, 1065, 3084, 1471, 2714, 2270,
	  34, 4029, 1869, 3446, 1207, 2442, 3919,  879, 1788, 3726, 1115, 3129, 1466, 2742, 3897,  214, 1750, 3763,  405, 3459,  123, 3916,  812, 2317, 1685,  533, 3389, 1589, 3908, 1844,  376, 3990, 1158, 3437, 2377,  458, 2645,  896, 2336, 3396,  193, 2581, 3539, 1083, 2756, 3871, 1426, 2135, 3166, 1824,  566, 2104, 3559,  413, 1814, 2922, 2122,  797, 2750, 2258,  670, 3944,  869, 1729,
	3183, 1409,  916, 2220, 3100,  568, 1427, 3351, 2601,  336, 2803,  778, 3656,  432, 2170, 3330,  944, 2302, 2856,  970, 2416, 1766, 3249, 1218, 4066, 2438,  993, 2635,  697, 3021, 2152,  830, 2608,  234, 1421, 4051, 1705, 3577, 1507,  791, 3807,  958, 2051, 3148,    4, 2256,  712, 3529,  179, 2536, 3880,  989, 2655, 1302, 3267,  562, 1210, 3517,  303, 1950, 3393,  168, 2125, 3749,
	 502, 2745, 3648,  256, 1620, 3684, 2240,  173, 1238, 3999, 2216, 1704, 2039, 2886, 1213, 1889, 2980,  665, 1585, 3715, 1333, 2662,  446, 3011,   41, 1906, 3772,  306, 3509, 1241, 3339, 1645, 3692, 2209, 3121,  607, 2833,   47, 3185, 2507, 1291, 2859,  400, 1580, 3675, 1328, 2676, 1658, 2857, 1183, 1965, 3190,  149, 3972, 1573, 2221, 3832, 1706, 3037, 1290, 2534, 1647, 2923, 1161,
	2452, 1942,  809, 3321, 2139, 1022, 2842, 1887, 3074, 1528,  536, 3475,  188, 3837,  752, 3573,   79, 4018, 2141,  285, 3354,  738, 3680, 2173, 1473, 2927, 1144, 2816,  877, 2368,   91, 2727,  635, 1253, 1888, 3513,  974, 2280, 1990,  488, 3326, 1948, 4007, 2153,  660, 3314,  302, 4039,  784, 3626,  445, 2327, 1674, 2513,  827, 3099,   26, 2464,  749, 4095,  912, 3704,  556, 3495,
	 225, 3962, 1567, 2550,  713, 4053,  371, 3436,  796, 2541, 3169, 1174, 2428, 1414, 2609, 1628, 2753, 1263, 3206, 1951, 1129, 2885, 1740,  911, 3376,  672, 3603, 1616, 2015, 3873, 1477, 3543, 2087, 3846,  171, 2549, 1612, 3730, 1157, 3923, 1650,  151, 1136, 3033, 2466,  996, 2931, 1450, 2391, 1763, 3362,  883, 3678,  333, 3496, 1422, 2730, 1084, 3225,  375, 2780, 1480, 2354, 1882,
	2961, 1028, 2814,   80, 3154, 1720, 2463, 1444, 3733,   23, 1666, 3917,  611, 3398,  388, 3235,  696, 2344,  425, 2580, 3839,  154, 2266, 3957,  381, 2056, 2476,  196, 3180,  527, 3009, 1044,  383, 2347, 2973,  781, 3227,  342, 2766,  654, 2967, 2101, 3546,  457, 1534, 3732, 1917,  616, 3134,   52, 2174, 2981, 1169, 2813, 2116,  541, 3781, 2156, 1448, 3578, 2199,   87, 3359, 1313,
	 618, 3424, 1397, 3818, 2098, 1095, 2943,  961, 2316, 1959, 2975, 1026, 2724, 1768, 2155, 1153, 3945, 1751, 3612,  814, 1551, 3304, 1178, 2764, 1643, 3136, 1081, 3981, 2213, 1310, 2587, 1826, 3369, 1533, 1092, 3953, 1296, 2433, 1833, 3598, 1023, 2543, 1309, 3187, 2043,  125, 2519, 3528, 1324, 3757, 1511,  492, 4057, 1910,  994, 3200, 1777,  212, 2960,  702, 1811, 3122,  943, 3925,
	2611, 2046,  477, 2397,  650, 3541,  235, 3864,  632, 3342,  423, 2234, 3592,  109, 3758, 2933,  239, 2790, 1051, 2985, 2113,  630, 2515,  257, 3778,  843, 2708, 1549,  653, 3521,  233, 4058,  748, 3086, 2231,  484, 2062, 3075,  115, 1501, 3287,  334, 3885,  856, 2763, 3971, 1195,  414, 2822,  681, 2700, 1830, 2422,  112, 3556, 2267,  901, 3983, 2373, 1217, 3770,  454, 2481, 1845,
	 266, 3662, 1654, 3208, 1287, 1934, 3060, 1807, 2648, 1395, 4074,  828, 1531, 2640, 1350,  872, 2454, 1512, 3499,    8, 4092, 1762, 3540, 1434, 2146, 3286,   71, 3683, 1902, 2421, 1385, 2719, 1972,   13, 3660, 1688, 3450, 1001, 4077, 2328,  907, 2913, 1690, 2353,  545, 1485, 2991, 2134, 1728, 3948,  938, 3353, 1298, 2891, 1592,  387, 3029, 1896,  524, 3378, 2092, 1560, 2972, 1089,
	3150,  882, 2672,  183, 3693, 2572,  506, 1109, 3218,  164, 2467, 1930, 3175,  706, 3480, 2111, 3831,  584, 2211, 2679, 1292, 2819,  442, 2935,  601, 1790, 2496, 1041, 2906,  435, 3230,  880, 3780, 2512,  909, 2770,  301, 2657, 1914,  508, 3754, 2079,   39, 3698, 1879, 3455,  800, 3322,  159, 2225, 3046,  304, 3621,  615, 3870, 2567, 1077, 3651, 1484, 2749,  190, 4008,  606, 3564,
	2203, 1410, 4046, 1988,  837, 1468, 3978, 2260, 1638, 3764,  929, 3547,  322, 1819, 2855,  394, 1416, 3006, 1702,  785, 3262,  960, 2249, 3624, 1224, 4023,  790, 3432, 1254, 3939, 1621, 2283,  531, 1519, 3394, 1258, 3819,  756, 3244, 1609, 2583, 1294, 3141, 1052, 2674,  261, 2427, 1553, 3653, 1165, 1962, 2606, 1040, 2320, 1937, 1284, 3160,   56, 2237,  920, 3194, 1372, 2401, 1952,
	   0, 2901,  689, 2338, 3352, 2840,   73, 3405,  739, 2054, 2959, 1377, 2202, 3941, 1067, 2021, 3306,  167, 3905, 2042,  307, 3792, 1860,  144, 2615, 1978, 3064,  278, 1945, 2383,  119, 3544, 1874, 3131,  203, 2187, 1767, 2462, 1229, 3585,  364, 2798,  683, 3503, 1412, 4049,  921, 2762,  447, 3144,  733, 3797, 1489, 2986,  231, 3474,  780, 2793, 3935, 1670, 2526,  367, 3315,  841,
	3855, 1734, 3489,  305, 1240, 1836, 2195, 1011, 3078,  390, 2556,  642, 3209,   44, 2743, 3679,  917, 2695, 1133, 3400, 2436, 1098, 3056, 1415, 3277,  487, 1568, 2643, 3670,  925, 3101, 1034, 2747, 1167, 4030, 2848,  580, 3094,   99, 2287, 1031, 3989, 1968, 2379,  514, 2053, 3092, 1234, 3894, 1623, 2472,   14, 3259,  822, 3968, 2248, 1401, 2040,  449, 3269,  766, 3706, 1603, 2944,
	1250, 2650, 1015, 2537, 3943,  579, 3630, 2593, 1274, 3467, 1583, 3829, 1162, 2471, 1543,  553, 2365, 1613, 3072,  677, 1748, 2752,  528, 3929,  906, 2321, 3810, 1288,  628, 2829, 2094, 3852,  401, 2392,  773, 1591, 3468, 1424, 3881, 1789, 3331, 1520,  172, 3220, 1636, 3596,   89, 1924, 2284, 1003, 3435, 1739, 2124, 2778, 1806,  517, 2621, 3403, 1205, 1829, 2869, 1062, 2293,  244,
	3608,  431, 3246, 1379, 2123, 2937, 1532,  296, 3922, 1865,  177, 2143, 2974,  427, 4011, 1912, 3576,  326, 2109, 4031,   75, 3655, 2206, 1541, 2048, 3401,   33, 2161, 3364, 1476,  254, 1691, 3337, 1375, 3605, 2055,  362, 2738,  716, 2634,  450, 2212, 3777, 1187, 2870,  863, 2485, 3363,  337, 3008,  634, 4063,  452, 1268, 3313, 1112, 3727,  253, 2228, 3798,  103, 1974, 4075, 1406,
	2430, 2061,  776, 3720,  152, 1114, 3293, 2325,  840, 2660, 3272,  988, 1725, 3366, 1305, 3020,  968, 3228,  799, 2544, 1840, 1016, 3170,  259, 2873,  777, 1838, 3142,  455, 3985, 2010, 2993,  646, 2689,   45, 2547, 3745, 1137, 3212, 1317, 3023,  825, 2566,  410, 2127, 3931, 1538,  775, 3812, 1785, 2757, 1368, 2542, 3584,  127, 3041, 2011, 1548, 2940,  723, 2490, 3307,  530, 2789,
	 948, 3123, 1579, 2777, 2035, 3848,  542, 1946, 3057, 1433,  558, 3731, 2600,  755, 2326,  108, 2785, 1380, 3750, 1276, 3451, 2063,  737, 3567, 1247, 4062, 2671,  884, 2411, 1126, 2588,  952, 3794, 1858, 3161,  924, 1804, 2333,  218, 3974, 1679, 3456, 1394, 3572, 1757,  211, 3205, 2659, 1242, 2346,  176, 3140,  850, 2188, 1716, 2460,  560, 4019,  997, 3522, 1735, 1105, 3048, 1661,
	3773,   61, 3548,  609, 1273, 2553, 1682, 3609,   25, 4056, 1898, 2233,  224, 3604, 1107, 3802, 1673, 2410,  246, 2849,  459, 3066, 2578, 1625, 2425,  368, 1463, 3734, 1671, 3510,  107, 3257, 1341,  460, 2239, 3947,  550, 3441, 1993,  971, 2408,   20, 2765, 1061, 2952, 2292, 1371,  434, 3642,  972, 3460, 1659, 3736,  330, 3904,  888, 3276, 1362, 2735,  356, 2281, 3901,  227, 2171,
	 805, 2528, 1774, 2183, 3165,  267, 2860, 1008, 2461, 1285, 2834,  935, 3081, 1509, 2694, 2073,  671, 3168, 1939, 1141, 3969, 1429,  133, 3815,  973, 3231, 2085,  201, 2918,  698, 2781, 1644, 2311, 3387, 1057, 1561, 2821, 1216, 2599, 3355,  701, 3791, 1892,  481, 4091,  651, 3310, 2191, 1700, 2899,  707, 2448, 1312, 2668, 1454, 2792, 2107,   36, 2030, 3234, 1465,  865, 2597, 3484,
	1518, 4000,  429, 3415,  870, 3949, 1503, 3492,  721, 3372,  361, 3789, 1831,  529, 3487,  320, 4081, 1012, 3607, 2250,  629, 2169, 3347, 1976, 2997,  722, 3620, 2351, 1200, 3889, 2144,  810, 4082,  236, 2023, 3515,  117, 3709,  444, 1835, 2845, 1299, 3198, 2140, 1510, 2546,  887, 3857,   49, 2009, 3994,  404, 3035, 1048, 3410,  461, 3668, 1618, 3828,  590, 2807, 3613, 1354,  620,
	3157, 1152, 2867, 1297, 2711, 2265,  490, 2131, 2955, 1712, 2350, 1214, 3203, 2179, 1069, 2577, 1857, 2924,   17, 2699, 1692, 2950, 1197,  485, 1582, 2740, 1407,  544, 3278, 1784,  382, 2941, 1208, 2510, 3063,  844, 2722, 2215, 1595, 4026,  226, 2370,  743, 3681,  145, 3465, 2068, 2782, 1392, 3153, 1006, 2255, 3638,  105, 1821, 2517,  813, 2920, 1189, 2409, 1967,  122, 3058, 2067,
	2403,  252, 1980, 3686,  116, 1652, 3746, 1337,  204, 3970,  669, 2715,   82, 3895, 1635, 3409,  763, 1526, 3502,  967, 3719,  268, 3900, 2393, 3558,   62, 3991, 1973, 2540,  987, 3716, 1909, 3327,  554, 1615, 3761, 1366,  595, 3300,  876, 3116, 1138, 2893, 1342, 2678, 1754,  378, 1079, 3563,  525, 2733, 1853, 1143, 2112, 4073, 1228, 3360, 1904,  377, 3391, 1042, 4050, 1721,  478,
	3860, 1624, 3270,  936, 2088, 2929,  610, 3145, 2444, 1486, 3534, 2007, 2996,  808, 2402,  199, 2828, 2100,  505, 3127, 1435, 2558, 2003,  613, 1852, 2633, 1117, 3164,  271, 3476, 2271,    3, 1469, 3853, 2362,  340, 2898, 1878, 2570, 1462, 2166, 3872,  335, 3367,  639, 3988, 2964, 1908, 2374, 1577, 3835,  281, 3481, 2839,  582, 3018,  187, 2276, 3928, 1597, 2652,  831, 2557, 3425,
	1119, 2836,  561, 2514, 4088, 1064, 3458, 1957,  886, 2841,  341, 1101, 1683, 3236, 1365, 3617, 1033, 3921, 2447, 1846,  750, 3402, 1087, 3065, 1308, 3439,  705, 1752, 2872, 1374,  848, 3207, 2637, 1030, 2065, 3462,  910, 3911,   57, 3623,  534, 1894, 2559, 1611, 2297, 1413,  746, 3783,  175, 3211,  905, 2527,  754, 1464, 2369, 1665, 3751, 1396,  652, 3040,  272, 3266, 1307, 2102,
	  15, 2274, 3526, 1432,  350, 1795, 2565,   48, 3883, 1269, 3411, 2136, 4027,  310, 2626,  645, 3113, 1311,  290, 3784, 2680,  113, 2268, 4068,  339, 1947, 2468, 3830,  526, 2078, 3950, 1711,  636, 3049,  166, 1731, 3108, 1184, 1999, 2669, 1349, 3500,  890, 3711,   78, 3290, 2502, 1201, 2853, 2184, 1357, 3303, 1926, 3884,  313, 2675,  789, 3171, 2437, 1265, 3718, 1920,  608, 2951,
	3766, 1569,  857, 2897, 2118, 3645,  762, 3182, 1629, 2360,  703, 2900,  954, 1876, 3759, 1488, 2289, 1911, 2956,  981, 1664, 3644,  918, 1562, 2904, 3661,  147, 1475, 3311, 2649,  230, 2245, 3636, 1386, 4022, 2603,  509, 2376, 3345,  847, 3059,  208, 2866, 1186, 2646, 1703,  366, 3392, 1823,  540, 4017,    6, 2987,  991, 3375, 1159, 3601, 2066,   68, 2772,  767, 2322, 3587, 1399,
	 519, 2181, 3879,  161, 3229, 1149, 2032, 2656,  417, 3767, 2018,  134, 3549, 2223,  552, 3284,   59, 3987,  589, 3444, 2339,  422, 2805, 2151,  563, 1196, 3199, 2345,  874, 1300, 3531, 1142, 2746,  372, 2182,  821, 3744, 1631,  269, 4070, 1587, 2405, 1782, 3887,  674, 3560, 2071,  942, 3669, 1513, 2571, 2089,  691, 2453, 1877, 2874,  468, 1717, 3525, 1430, 3960, 1626,  207, 2734,
	1832, 3000, 1203, 2585, 1749,  463, 3986, 1355, 3349,  975, 3054, 1604, 2607, 1182, 2938, 1698, 2574, 1227, 2794, 2069, 1146, 3260, 1316, 3876, 1794, 2681, 1996,  473, 3993, 1936, 3032,  567, 2001, 3397, 1478, 3252, 1148, 2954, 1929, 2272,  623, 3167,  420, 2158, 2930, 1121, 3085, 2441,  221, 2892, 1082, 3610, 1602, 3803,  157, 1523, 4044, 2285, 1043, 2912,  456, 2516, 3454,  978,
	4037,  315, 3361,  622, 3691, 2194, 2984,  189, 1815, 2530,  497, 3271,  740, 3859,  270, 3671,  834, 3511, 1771,  186, 3743,  718, 3015,   29, 3373,  819, 3762, 1578, 2755,   77, 2414, 1634, 3915,  881, 2826,   94, 2560,  467, 3520, 1260, 3724, 1360, 3473, 1498,  163, 4009,  555, 1851, 3800,  787, 3251,  299, 3039, 1232, 3268, 2229,  662, 3002,  242, 1899, 3295, 1198, 1989, 3159,
	 709, 2443, 2041, 1525, 2666, 1275,  859, 2090, 3557, 1116, 4054, 1437, 2404, 1944, 2810, 1068, 2352,  385, 3156, 2450, 1472, 2639, 1710, 2366, 1140, 2884,  262, 3239,  964, 3690,  807, 3135,  251, 2384, 1699, 3865, 1318, 3098,  779, 2486,   18, 2631,  914, 2799, 1919, 2364, 1566, 3334, 1255, 2304, 1656, 2688, 2047,  574, 2653, 1091, 3408, 1332, 3844, 2445,  631, 3737,   93, 2290,
	1646, 3672, 1046, 3508,   70, 3886, 2419, 3213,  346, 2815, 2138,    5, 3430,  614, 1479, 3374, 1651, 4064, 1353,  771, 3888,  344, 3545,  667, 4035, 1859, 2497, 1320, 2300, 1765, 2632, 1436, 3658, 1118, 3350,  731, 2315, 1843, 3956, 1010, 3316, 2082, 3918,  472, 3640,  744, 2690,   65, 2823,  428, 4078,  854, 3570, 1458, 3952,  354, 2014, 2624,  836, 1497, 3042, 1709, 2771, 1103,
	2990,  228, 2862,  811, 3189, 1736,  512, 1482, 3809,  710, 1773, 3034, 1346, 3951, 2291,  141, 2890,  585, 2696, 2022, 2910, 1055, 2197, 3139, 1382,  489, 3635,  621, 3461,  220, 4080,  546, 1881, 2958,  412, 1998, 3588,  184, 1455, 2761, 1605,  717, 1778, 3188, 1170, 3030, 1391, 3862, 1905, 3423, 1063, 2505,  101, 1932, 2429, 1267, 3701,   37, 3488, 2083,  294, 4013,  803, 3470,
	1387, 3907, 1793, 2324, 1244, 2800, 2006, 3068,  980, 2385, 3628, 1050, 2729,  380, 1798, 3739,  928, 2232, 3413,   81, 1669, 3329, 1524,  216, 2703, 2097, 2936, 1639, 2045, 2712, 1344, 2167, 3494, 1019, 2458, 3158, 1168, 2592, 3448,  440, 3788, 2945,  202, 2474, 1995,  321, 3501, 1018,  577, 2176, 3083, 1373, 2865, 3344,  513, 3093, 1600, 2832, 1099, 3143, 2303, 1025, 2622,  363,
	2263,  668, 2717,  395, 4071,  659, 3673,  137, 2682, 1660,  275, 3210,  824, 2423, 3308, 1270, 3095, 1856, 1221, 3652, 2529,  576, 3961, 1895, 3735, 1124,   90, 3890,  941, 3255,  817, 2881,   32, 2731, 1715,  312, 4047,  649, 1986, 2358, 1246, 1927, 3574,  838, 4048, 2341, 1722, 2610, 3247, 1556,  276, 3677,  643, 1164, 3806, 2261,  774, 1903, 3913,  641, 1461, 3282, 1769, 3657,
	1614, 3325, 1175, 3133, 1565, 2483, 1113, 3297, 1319, 4003, 2241, 1236, 3838, 1606,  655, 2751,  248, 3920,  464, 2149,  950, 3045, 1261, 2825,  736, 2432, 3358, 1442, 2511,  323, 3725, 1527, 3940,  862, 3602, 2257, 1581, 2797,  998, 3147,  284, 2705, 1045, 2889, 1504,  648, 3073,  185, 1243, 3902, 2310, 1746, 2117, 2710, 1521,  180, 3516, 2647,  318, 2489, 3682,  143, 2908,  732,
	2508,   22, 3822, 1954,  222, 3483, 2137,  474, 2902,  588, 3114, 2034,  114, 2882, 3666, 1822, 1059, 2323, 3216, 1329, 3805,  155, 2298,  402, 3128, 1540, 2177,  656, 3061, 1800, 2313,  523, 1915, 3089, 1376,  694, 3281,   83, 3688, 1727, 3966, 1451, 3265,   50, 2064, 3697, 1335, 3449, 2028,  758, 2791,  949, 3996,  351, 3241, 2172, 1805,  995, 3079, 1131, 1872, 2389, 1220, 3973,
	1336, 2838,  931, 2361, 2992,  788, 1714, 3878, 2208, 1842,  976, 3532, 1358, 2103,  475, 2230, 3491, 1558,  734, 2817, 1741, 3431, 1384, 3705,  899, 3565,  274, 3997, 1166, 3538,  922, 3390, 2614,  209, 2390, 3877, 1188, 3010, 2157,  801, 2500,  522, 2218, 3849, 2539,  470, 2723,  897, 2473, 3614,   21, 3386, 1447, 3016,  895, 3874,  504, 3619, 1542, 4089,  692, 3440, 2057,  493,
	3245, 1759, 3615,  543, 1491, 3768, 2576, 1266,   46, 3643, 2545,  353, 2661, 4094, 1135, 2932,   38, 2564, 4010,  286, 2386,  802, 2684, 1770, 2522, 1321, 2914, 1689, 2673,  121, 2888, 1755, 1212, 3466, 1992,  462, 2605, 1864,  360, 3299, 1219, 3527, 1667,  685, 1185, 3223, 1966, 4006,  418, 1594, 3112, 2253,  591, 1900, 2449, 1364, 2864, 1970,   67, 2254, 2827,  329, 2971, 1058,
	2296,  283, 2617, 1873, 3152, 1120,  389, 3263, 2725, 1552,  726, 3226, 1686,  604, 3280, 1500, 3695,  999, 2025, 3192, 1078, 2979,  451, 4061,   10, 3221,  753, 2331,  984, 3842, 2160,  407, 4021,  878, 2966, 1545, 3536,  945, 3813, 1599, 2748,  178, 3118, 2008, 3631, 1608,  136, 1419, 2934, 2189,  682, 1326, 3729, 2736,  131, 3420,  818, 2521, 3320,  898, 1668, 3841, 1431, 3713,
	1536, 3406, 1007, 4034,  128, 2244, 3575, 2016,  951, 3930, 2299, 1020, 3748, 2435, 1925,  324, 2200, 3043,  571, 1775, 3785, 1456, 3275, 1151, 2165, 1803, 3793,  316, 3291, 1923, 1090, 3076, 2426, 1841,  612, 3201,  160, 2278, 2830,  549, 2132, 4093,  867, 2591,  365, 2769, 2114, 3553, 1004, 3821, 1828, 3336,  338, 1607, 4041, 1202, 3067,  419, 1327, 3583, 2190,  793, 2677,  100,
	2480,  764, 2921, 2133, 1282, 2801, 1388,  657, 3173,  279, 1820, 2965,  132, 1231, 2812, 3938,  861, 1440, 3590, 2663,  120, 2282,  675, 2620, 3554,  969, 2488, 1598, 2824,  495, 3641, 1505,   54, 3771, 2243, 1381, 3977, 1960, 1279, 3569, 1036, 1786, 2994, 1378, 3906, 1074, 3343,  572, 2518,  206, 2877,  868, 2413, 3155,  581, 2308, 1697, 3808, 2024, 2718,  240, 3202, 1233, 3497,
	1718, 3863,  406, 1632, 3381,  511, 3963, 2440, 1470, 2619, 3341, 1315, 2217, 3593,  557, 1760, 3324, 2501,  408, 1314, 3479, 1708, 3896, 1554,  247, 3017,  638, 3418, 1334, 2455,  816, 3377, 2142, 1029, 2878,  437, 2551,  687, 2957,    7, 2491, 3332,  273, 2334,  782, 2968, 1783, 1278, 3124, 2074, 1490, 3942, 2004, 1066, 1907, 3568,  191, 2796,  605, 1122, 3995, 1850, 2273,  695,
	3130, 1156, 2356, 3728,  915, 3105, 2059,  170, 3753, 1080,  503, 4016,  804, 3115, 1361, 2693,   86, 1837, 3854, 2349,  769, 2846,  393, 3117, 2072, 1257, 3867, 2031,  135, 4084, 1958, 2709,  708, 3243, 1570, 3708, 1130, 3419, 1695, 3858, 1508,  658, 3786, 1707, 3472,   69, 2434, 4052,  421, 3599,  664, 2573,   53, 3382, 2642,  957, 3193, 1499, 2238, 3024, 1559,  494, 3689, 2584,
};

#endif /* AVFILTER_DITHER_MATRIX_H */
