/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVUTIL_WCHAR_FILENAME_H
#define AVUTIL_WCHAR_FILENAME_H

#ifdef _WIN32
#include <windows.h>
#include "mem.h"

av_warn_unused_result
static inline int utf8towchar(const char *filename_utf8, wchar_t **filename_w)
{
    int num_chars;
    num_chars = MultiByteToWideChar(CP_UTF8, MB_ERR_INVALID_CHARS, filename_utf8, -1, NULL, 0);
    if (num_chars <= 0) {
        *filename_w = NULL;
        return 0;
    }
    *filename_w = (wchar_t *)av_calloc(num_chars, sizeof(wchar_t));
    if (!*filename_w) {
        errno = ENOMEM;
        return -1;
    }
    MultiByteToWideChar(CP_UTF8, 0, filename_utf8, -1, *filename_w, num_chars);
    return 0;
}

av_warn_unused_result
static inline int wchartoutf8(const wchar_t *filename_w, char **filename_utf8)
{
    int num_chars;
    num_chars = WideCharToMultiByte(CP_UTF8, WC_ERR_INVALID_CHARS, filename_w, -1, NULL, 0, NULL, NULL);
    if (num_chars <= 0) {
        *filename_utf8 = NULL;
        return 0;
    }
    *filename_utf8 = av_mallocz(num_chars);
    if (!*filename_utf8) {
        errno = ENOMEM;
        return -1;
    }
    WideCharToMultiByte(CP_UTF8, 0, filename_w, -1, *filename_utf8, num_chars, NULL, NULL);
    return 0;
}
#endif

#endif /* AVUTIL_WCHAR_FILENAME_H */
