# MPV Advanced Configuration

MPV running inside Plex and Plex HTPC can be specially configured via an `mpv.conf` file in this same directory. Directives added to this file will be read by the MPV library before each playback. For information on what can be added to this file, please see [the manual](https://mpv.io/manual/master/).

Note:  If you use directives which don't set absolute values, the effect will be magnified with each playback.  For example, if you put in `vf-add=vflip`, then half the playbacks will have the video flipped and half will not (because each playback adds the `vflip` video filter and when it is present an even number of times, thus cancelling each other out).  But a `vf=vflip` will flip the video every time because the video filter chain is being set to exactly `vflip`.

## Overridden Directives

To facilitate the normal operation of Plex and Plex HTPC and settings the user can configure in the UI, some settings in the `mpv.conf` file will be overridden by the application. These include:

- `aid`
- `audio-client-name`
- `audio-delay`
- `audio-display`
- `audio-normalize-downmix`
- `deinterlace`
- `demuxer-lavf-probe-info`
- `demuxer-mkv-probe-start-time`
- `demuxer-seekable-cache`
- `gpu-hwdec-interop`
- `gpu-shader-cache-dir`
- `input-builtin-bindings`
- `sid`
- `speed`
- `sub-delay`
- `title`
- `tls-verify`
- `tls-ca-file`
- `volume`

Other settings are set by Plex and Plex HTPC but the `mpv.conf` can override these values.  Note that if a setting is changed during playback (UI interaction, input mapped to a command, etc), it'll then override whatever was set before it.

- `audio-channels`
- `audio-device`
- `audio-exclusive`
- `audio-spdif`
- `correct-downscaling`
- `cscale-antiring`
- `cscale`
- `deband-iterations`
- `deband-threshold`
- `deband`
- `demuxer-max-back-bytes`
- `demuxer-max-bytes`
- `dither-depth`
- `dscale-antiring`
- `dscale`
- `glsl-shaders`
- `hdr-compute-peak`
- `hwdec`
- `input-default-bindings`
- `keepaspect`
- `linear-downscaling`
- `osd-level`
- `panscan`
- `scale-antiring`
- `scale`
- `sigmoid-upscaling`
- `sub-align-x`
- `sub-align-y`
- `sub-border-color`
- `sub-color`
- `sub-create-cc-track`
- `sub-font-size`
- `target-colorspace-hint`
- `video-aspect-override`
- `vo`


Note: This list is subject to change in future versions of Plex apps. This file will be updated when this changes.
