// Copyright 2020 Plex, Inc. All rights reserved.

#pragma once

#if defined(INCLUDE_PMS_LOGGER) || (defined(INCLUDE_MINIMAL_SERVER) && defined(INSIDE_SERVER))
#include "pms_export.h"
#else
#define PMS_EXPORT
#endif

class PMS_EXPORT ScopedLogContextStack
{
public:
  ScopedLogContextStack(std::list<std::string> contextStack = std::list<std::string>());

  ~ScopedLogContextStack();

  std::list<std::string> m_contextStack;

  // Noncopyable, nonmovable
  ScopedLogContextStack(const ScopedLogContextStack&) = delete;
  ScopedLogContextStack(ScopedLogContextStack&&) = delete;
};
