// Copyright 2020 Plex, Inc. All rights reserved.

#include "pms_export.h"

// It is possible to use PMS_EXPORT by-member, but in that case, it has to be
// removed from the class itself. Since we are exporting all of these members
// we'll just set it on the class.
class PMS_EXPORT NanoCodecFetcher
{
public:
  enum class Status
  {
    /// The codec is already downloaded
    AlreadyExists,

    /// Successfully downloaded the codec
    Successful,

    /// Received a server error while attempting to fetch the codec
    ServerError,

    /// There is no such named codec
    NotFound,
  };

  static Status FetchDecoder(const std::string& name);
};
