#include <string>

#include "pms_export.h"


// It is possible to use PMS_EXPORT by-member, but in that case, it has to be
// removed from the class itself. Since we are exporting all of these members
// we'll just set it on the class.
class PMS_EXPORT NanoSettings
{
public:
  // These must be called before other threads are started because they may set environment variables
  static void SetupEnvironment();
  static void SetListenPort(unsigned short port);
  static void SetAppSupportDir(const std::string& dir);

  // These should be called before the server is started and may be called additional times after it is started
  static void SetToken(const std::string& token);
  static void SetClientID(const std::string& clientId);

  // This is called once.  If called multiple times, subsequent times will not do anything.  This function spawns its own thread and does not block
  static void StartServer(bool pico = false);

  // This is called once.  Note, this function will block until the server has shutdown.  Client should call  _Exit/TerminateProcess to actually terminate the process
  static void StopServer();

  // These may be called at any time after the server is started
  static void RestartHttpServer();

  // These may be called at any time but value can change after a call to #SetAppSupportDir
  static std::string GetCodecsDir();
};
