# Input Maps

Plex and Plex Media Player use input maps to map various kinds of input keys into commands. You can see [https://support.plex.tv/articles/216459997-create-your-own-inputmap/](https://support.plex.tv/articles/216459997-create-your-own-inputmap/) for basic instructions in input maps. The input maps all have an `idmatcher` which is a regular expression to match against the id of the input and each key is matched via a regular expression to one or multiple actions (see doc for more information).

In this same directory is a directory named `default`. This contains the default mappings and is always copied from the application's actual default mappings. Changes to files in this dir will not affect anything and will be overwritten on the next launch of the application. If you wish to override the defaults, copy the relevant input map out of the `default` directory and into this directory and make your modifications to that file. Any files in this directory which have the same `name` will override any previously read files with the `name`.

## Commands

Plex and Plex Media Player supports keyboard literals (such as `A`) as well as a set of commands. The set of supported commands is:

- `back`
- `cycle_aspect_ratio`
- `cycle_audio`
- `cycle_audio_back`
- `cycle_subtitles`
- `cycle_subtitles_back`
- `debug`: Display debug information overlay
- `decrease_audio_delay`
- `decrease_subtitles_delay`
- `decrease_volume`
- `down`
- `enter`
- `exit`
- `home`
- `increase_audio_delay`
- `increase_subtitles_delay`
- `increase_volume`
- `info`
- `jump+{letter}`: Jumps to the specified letter (or number) in an alphabetical list
- `left`
- `mpv:{command}`: Sends a raw command into mpv. Example: `mpv:set sub-scale=2`.
- `next_pivot_tab`
- `pause`
- `play`
- `play_pause`
- `poweroff`
- `previous_pivot_tab`
- `reboot`
- `right`
- `search`
- `seek_backward`
- `seek_forward`
- `skip_previous`
- `skip_next`
- `step_backward`
- `step_forward`
- `stop`
- `suspend`
- `toggle_fullscreen`
- `toggle_subtitles`
- `toggle_watched`
- `up`

## Keys

The set of keys for some inputs is restricted to a pre-defined set. Sometimes guessing the key for a particular input action can go awry so if this is in doubt, check the application logs; it will log the input it sees even if it doesn't have an action to take on it. Some examples of known inputs are provided below:

### Keyboard

Keyboard keys are typically the raw key that is pressed along with modifiers. Modifiers are prefixed with the modifier string followed by a `+` and the actual key. See [https://doc.qt.io/qt-5/qkeysequence.html#toString](https://doc.qt.io/qt-5/qkeysequence.html#toString) for more information on the format of this string. Note: On the Mac the modifiers are not always named as you expect. The `cmd` key is named `Ctrl`, the `opt` key is named `Alt`, and the `ctrl` key is named `Meta`. Pressing `cmd-ctrl-opt-shft-h` results in the input key: `Ctrl+Meta+Alt+Shift+H` (respectively).

### CEC

Note: Particular CEC setups may not send certain keys into the application; this is the full set of keys the library currently supports and could potentially make it into the application.

- `KEY_AN_CHANNELS_LIST`
- `KEY_AN_RETURN`
- `KEY_ANGLE`
- `KEY_BACK`
- `KEY_BLUE`
- `KEY_CHANNEL_DOWN`
- `KEY_CHANNEL_UP`
- `KEY_CLEAR`
- `KEY_CONTENTS_MENU`
- `KEY_DATA`
- `KEY_DOT`
- `KEY_DOWN`
- `KEY_DVD_MENU`
- `KEY_EJECT`
- `KEY_ELECTRONIC_PROGRAM_GUIDE`
- `KEY_ENTER`
- `KEY_F5`
- `KEY_FAVORITE_MENU`
- `KEY_GREEN`
- `KEY_GUIDE`
- `KEY_HELP`
- `KEY_HOME`
- `KEY_INFO`
- `KEY_INITIAL_CONFIGURATION`
- `KEY_INPUT_SELECT`
- `KEY_LEFT`
- `KEY_MENU`
- `KEY_MUTE_FUNCTION`
- `KEY_MUTE`
- `KEY_NEXT_FAVORITE`
- `KEY_NEXT`
- `KEY_NUMERIC_0`
- `KEY_NUMERIC_1`
- `KEY_NUMERIC_11`
- `KEY_NUMERIC_12`
- `KEY_NUMERIC_2`
- `KEY_NUMERIC_3`
- `KEY_NUMERIC_4`
- `KEY_NUMERIC_5`
- `KEY_NUMERIC_6`
- `KEY_NUMERIC_7`
- `KEY_NUMERIC_8`
- `KEY_NUMERIC_9`
- `KEY_PAGE_DOWN`
- `KEY_PAGE_UP`
- `KEY_PAUSE_PLAY_FUNCTION`
- `KEY_PAUSE_RECORD_FUNCTION`
- `KEY_PAUSE_RECORD`
- `KEY_PAUSE`
- `KEY_PLAY_FUNCTION`
- `KEY_PLAY`
- `KEY_POWER_OFF_FUNCTION`
- `KEY_POWER_ON_FUNCTION`
- `KEY_POWER_TOGGLE_FUNCTION`
- `KEY_POWER`
- `KEY_PREV`
- `KEY_PREVIOUS_CHANNEL`
- `KEY_RECORD_FUNCTION`
- `KEY_RECORD`
- `KEY_RED`
- `KEY_RESTORE_VOLUME_FUNCTION`
- `KEY_RIGHT`
- `KEY_SEEKBCK`
- `KEY_SEEKFWD`
- `KEY_SELECT_AUDIO_INPUT_FUNCTION`
- `KEY_SELECT_AV_INPUT_FUNCTION`
- `KEY_SELECT_BROADCAST_TYPE`
- `KEY_SELECT_MEDIA_FUNCTION`
- `KEY_SELECT_SOUND_PRESENTATION`
- `KEY_SELECT`
- `KEY_SETUP_MENU`
- `KEY_SOUND_SELECT`
- `KEY_STOP_FUNCTION`
- `KEY_STOP_RECORD`
- `KEY_STOP`
- `KEY_SUBTITLES`
- `KEY_TIMER_PROGRAMMING`
- `KEY_TOP_MENU`
- `KEY_TUNE_FUNCTION`
- `KEY_UP`
- `KEY_VIDEO_ON_DEMAND`
- `KEY_VOLUME_DOWN`
- `KEY_VOLUME_UP`
- `KEY_YELLOW`

### Joysticks

Joystick "Keys" are mostly named as `KEY_BUTTON_n` for the `n`th button and `KEY_AXIS_m_UP` for the `m`th axis (with `DOWN` instead of `UP` to indicate a "downwards" direction). Note that the numbers for `n` and `m` can differ across controllers and even different mechanims of accessing the same controller. Check the logs when unsure about the naming of keys.

Some joysticks are disabled by default (by commenting out the `idmatcher`) because they can cause conflicts if enabled by default. See individual json files for details.

### LIRC

LIRC keys names come directly from the LIRC mapping. If an IR command is configured in LIRC to send the key `KEY_LALALA`, then the key in the input mapping will be `KEY_LALALA`.
