#include <string>

#include "pms_export.h"


// It is possible to use PMS_EXPORT by-member, but in that case, it has to be
// removed from the class itself. Since we are exporting all of these members
// we'll just set it on the class.
class PMS_EXPORT NanoSettings
{
public:
  // These must be called before other threads are started
  static void SetupEnvironment();
  static void SetListenPort(unsigned short port);
  static void SetAppSupportDir(const std::string& dir);

  // This should be called before the server is started and may be called after it is started
  static void SetToken(const std::string& token);

  // This is called once.  If called multiple times, subsequent times will not do anything
  static void StartServer();

  // This is called once.  Note, this function will block until the server has shutdown
  static void StopServer();

  // These may be called at any time after the server is started
  static void RestartHttpServer();

  // These may be called at any time
  static std::string GetCodecsDir();
};
