#!/bin/sh
. /etc/service.subr

SCRIPTPATH=$(dirname $(realpath $0))

# set identification variables
export PLEX_MEDIA_SERVER_INFO_VENDOR=Drobo
export PLEX_MEDIA_SERVER_INFO_DEVICE="Drobo $(cat /sys/bus/scsi/devices/0:0:0:0/model|xargs)"
export PLEX_MEDIA_SERVER_INFO_MODEL="$(uname -m)"
export PLEX_MEDIA_SERVER_INFO_PLATFORM_VERSION="$(wget -O - -q -t 1 --timeout=1 http://127.0.0.1:5000|awk -F '[<>]' '/mVersion/{print $3;exit}')"

export LD_LIBRARY_PATH="${SCRIPTPATH}/Application/lib"
export PLEX_MEDIA_SERVER_HOME="${SCRIPTPATH}/Application"
export PLEX_MEDIA_SERVER_MAX_PLUGIN_PROCS=6
export PLEX_MEDIA_SERVER_PIDFILE="/tmp/DroboApps/plex/pid.txt"
export PLEX_MEDIA_SERVER_APPLICATION_SUPPORT_DIR="${SCRIPTPATH}/Library"
export PLEX_MEDIA_SERVER_DEFAULT_PREFERENCES='TranscoderCanOnlyRemuxVideo=true'
export PLEX_BROWSER_ROOT="/mnt/DroboFS/Shares"
export TMPDIR="${PLEX_MEDIA_SERVER_APPLICATION_SUPPORT_DIR}/tmp"
export LC_ALL="C"
export LANG="C"
ulimit -s 3000

name="plex"
version="1.15.0.545-c0e6af42a"
pidfile=/tmp/DroboApps/plex/pid.txt
description="Plex organizes all of your personal media so you can easily access and enjoy it."
framework_version="2.0"

start() {

  # if this file doesn't exist, client connections get some ugly warnings.
  touch /var/log/lastlog

  # make sure temp directory exists.
  mkdir -p ${TMPDIR} > /dev/null 2>&1

  # start Plex Media Server.
  ${SCRIPTPATH}/Application/Plex\ Media\ Server &
}

case "$1" in
  start)
    start_service
    exit $?
  ;;

  stop)
    set_enabled ${name} "NO"
    if [ -f $pidfile ]; then
      pid=`cat $pidfile`
      kill -INT $pid
    fi
    exit $?
  ;;

  restart)
    stop_service
    sleep 3
    start_service
    exit $?
  ;;

  status)
    status
  ;;

  *)
    echo "Usage: $0 [start|stop|restart|status]"
    exit 1
  ;;
esac
