#!/bin/sh

# Set identification variables for FreeNAS; with fallback to FreeBSD
if [ -f "/etc/version" ]; then
  export PLEX_MEDIA_SERVER_INFO_VENDOR="$(cat /etc/version|cut -d- -f1)"
  export PLEX_MEDIA_SERVER_INFO_DEVICE=NAS
  export PLEX_MEDIA_SERVER_INFO_MODEL="$(uname -m)"
  export PLEX_MEDIA_SERVER_INFO_PLATFORM_VERSION="$(cat /etc/version|cut -d- -f2-)"
else
  export PLEX_MEDIA_SERVER_INFO_VENDOR=FreeBSD
  export PLEX_MEDIA_SERVER_INFO_DEVICE=PC
  export PLEX_MEDIA_SERVER_INFO_MODEL="$(uname -m)"
  export PLEX_MEDIA_SERVER_INFO_PLATFORM_VERSION="$(uname -r)"
fi

SCRIPT=$(readlink -f $0)
SCRIPTPATH=$(dirname ${SCRIPT})
export PLEX_MEDIA_SERVER_HOME="${SCRIPTPATH}"
export PLEX_MEDIA_SERVER_MAX_PLUGIN_PROCS=6
export LC_ALL="en_US.UTF-8"
export LANG="en_US.UTF-8"
export PYTHONHOME="${SCRIPTPATH}/Resources/Python"
export PATH="${SCRIPTPATH}/Resources/Python/bin:${PATH}"
ulimit -s 3000
./Plex\ Media\ Server &
